% TechnologyInfusionInterface1.m
% by Darren Chang (darrenz@mit.edu)
% last modified: 10/18/02

function [addSCMass,addChannelFactor,addDVCost,addFUCost,newTech,ISL_new,Risl_new,GT_dB_new] = ...
    TechnologyInfusionInterface1(ISL,freq,GT_dB,Risl,TIIoption)
addSCMass  = 0;         % [kg]
addChannelFactor = 1;   % [-]
addDVCost  = 0;         % [K$]
addFUCost  = 0;         % [K$]
ISL_new = ISL;
Risl_new = Risl;
GT_dB_new = GT_dB;

wavelength = 3e8/(freq*1e6);

for i=1:3
    tech(i) = 0;
end;

if TIIoption(1) == 1
    tech(1) = 1;
end;

if TIIoption(2) == 1
    tech(2) = 1;
end;

if TIIoption(3) == 1
    tech(3) = 1;
end;

newTech='';
if tech(1) == 1
    newTech = strcat(newTech,'OISL.');
end;
if tech(2) == 1
    newTech = strcat(newTech,'ATM.');
end;
if tech(3) == 1
    newTech = strcat(newTech,'LDR.');
end;

for i=1:3
    Mass = 0;
    ChannelFactor = 1;
    DVCost = 0;
    FUCost = 0;
    if tech(i) == 1 & i == 1
        %OISL;
% Optical Inter-Satellite Link    
% Darren Chang (darrenz@mit.edu)
% last modified: 8/7/02

% Before technology infusion of optical ISL, no ISL or
% RF ISL is assumed used.


OISL_ChannelFactor = 1;      % [-]

if ISL == 1
    if 0 < Risl < 100                % data rate less than 100Mb/s
        OISL_mass = -309;        % [kg]
        OISL_DVCost = 11.86e3;      % [K$]. The ADDITIONAL development cost beyond RF ISL
        OISL_FUCost = 38.31e3;      % [K$]. The ADDITIONAL first unit cost beyond RF ISL
	elseif Risl >= 100
        OISL_mass = -363;
        OISL_DVCost = 8.47e3;       % [K$]. The ADDITIONAL development cost beyond RF ISL
        OISL_FUCost = 36.61e3;      % [K$]. The ADDITIONAL first unit cost beyond RF ISL
    end;
elseif ISL == 0
    OISL_mass = 117;
    OISL_DVCost = 25.42e3;         % [K$]
    OISL_FUCost = 67.80e3;         % [K$]
end;

ISL_new = 1;
Risl_new = 1e4;         % 10Gbps data rate for OISL
Mass    = OISL_mass;    %*OISL_unit;     
ChannelFactor = OISL_ChannelFactor;
DVCost = OISL_DVCost;
FUCost = OISL_FUCost;
    elseif tech(i) == 1 & i == 2
        % ATM.m
% Asynchronous Transfer Mode    
% Darren Chang (darrenz@mit.edu)
% last modified: 8/7/02
ATM_unit = 1;
ATM_mass = 100;             % [kg]
ATM_ChannelFactor = 1.5;    % [-]
ATM_DVCost = 40000;         % [K$]
ATM_FUCost = 12500;         % [K$]
Mass    = ATM_mass*ATM_unit;
ChannelFactor = ATM_ChannelFactor;
DVCost = ATM_DVCost;
FUCost = ATM_FUCost*ATM_unit;
    elseif tech(i) == 1 & i == 3
        % LDR.m
% Large-Scale Deployable Reflector
% Darren Chang (darrenz@mit.edu)
% last modified: 8/23/02

% The physical structure of the antenna is used.
% So the antenna transmitter gain before the technology infusion will be useless.
% But the transmitter power is still valid as a design variable.

DSatT = 18;                         % [m]. The LDR on ETS-VIII is 17x19 [m]

LDR_unit = 2;
LDR_mass = 9.173*DSatT^1.403;     % [kg], same antenna mass equation as in s/c module
LDR_ChannelFactor = 1;      % [-]
LDR_DVCost = 84700;         % [K$]
LDR_FUCost = 7500;          % [K$]

GTnew = (DSatT/wavelength*pi)^2;
GT_dB_new = ones(length(GT_dB),1);
GT_dB_new = GT_dB_new.*10*log10(GTnew);

Mass    = LDR_mass*LDR_unit;     
ChannelFactor = LDR_ChannelFactor;
DVCost = LDR_DVCost;
FUCost = LDR_FUCost*LDR_unit;
    end;
    addSCMass  = addSCMass + Mass;
    addChannelFactor = addChannelFactor*ChannelFactor;
    addDVCost  = addDVCost + DVCost;
    addFUCost  = addFUCost + FUCost;
end;